/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.mvstore;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.h14199.mvstore.DataUtils;
import org.h14199.mvstore.WriteBuffer;

public class Chunk {
    public static final int MAX_ID = 0x3FFFFFF;
    static final int MAX_HEADER_LENGTH = 1024;
    static final int FOOTER_LENGTH = 128;
    public final int id;
    public long block;
    public int len;
    public int pageCount;
    public int pageCountLive;
    public long maxLen;
    public long maxLenLive;
    public int collectPriority;
    public long metaRootPos;
    public long version;
    public long time;
    public long unused;
    public int mapId;
    public long next;

    Chunk(int n) {
        this.id = n;
    }

    static Chunk readChunkHeader(ByteBuffer byteBuffer, long l) {
        int n = byteBuffer.position();
        byte[] byArray = new byte[Math.min(byteBuffer.remaining(), 1024)];
        byteBuffer.get(byArray);
        try {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 10) continue;
                byteBuffer.position(n + i + 1);
                String string = new String(byArray, 0, i, StandardCharsets.ISO_8859_1).trim();
                return Chunk.fromString(string);
            }
        }
        catch (Exception exception) {
            throw DataUtils.newIllegalStateException(6, "File corrupt reading chunk at position {0}", l, exception);
        }
        throw DataUtils.newIllegalStateException(6, "File corrupt reading chunk at position {0}", l);
    }

    void writeChunkHeader(WriteBuffer writeBuffer, int n) {
        long l = writeBuffer.position();
        writeBuffer.put(this.asString().getBytes(StandardCharsets.ISO_8859_1));
        while ((long)writeBuffer.position() - l < (long)(n - 1)) {
            writeBuffer.put((byte)32);
        }
        if (n != 0 && writeBuffer.position() > n) {
            throw DataUtils.newIllegalStateException(3, "Chunk metadata too long", new Object[0]);
        }
        writeBuffer.put((byte)10);
    }

    static String getMetaKey(int n) {
        return "chunk." + Integer.toHexString(n);
    }

    public static Chunk fromString(String string) {
        HashMap<String, String> hashMap = DataUtils.parseMap(string);
        int n = DataUtils.readHexInt(hashMap, "chunk", 0);
        Chunk chunk = new Chunk(n);
        chunk.block = DataUtils.readHexLong(hashMap, "block", 0L);
        chunk.len = DataUtils.readHexInt(hashMap, "len", 0);
        chunk.pageCount = DataUtils.readHexInt(hashMap, "pages", 0);
        chunk.pageCountLive = DataUtils.readHexInt(hashMap, "livePages", chunk.pageCount);
        chunk.mapId = DataUtils.readHexInt(hashMap, "map", 0);
        chunk.maxLen = DataUtils.readHexLong(hashMap, "max", 0L);
        chunk.maxLenLive = DataUtils.readHexLong(hashMap, "liveMax", chunk.maxLen);
        chunk.metaRootPos = DataUtils.readHexLong(hashMap, "root", 0L);
        chunk.time = DataUtils.readHexLong(hashMap, "time", 0L);
        chunk.unused = DataUtils.readHexLong(hashMap, "unused", 0L);
        chunk.version = DataUtils.readHexLong(hashMap, "version", n);
        chunk.next = DataUtils.readHexLong(hashMap, "next", 0L);
        return chunk;
    }

    public int getFillRate() {
        if (this.maxLenLive <= 0L) {
            return 0;
        }
        if (this.maxLenLive == this.maxLen) {
            return 100;
        }
        return 1 + (int)(98L * this.maxLenLive / this.maxLen);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        return object instanceof Chunk && ((Chunk)object).id == this.id;
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder(240);
        DataUtils.appendMap(stringBuilder, "chunk", this.id);
        DataUtils.appendMap(stringBuilder, "block", this.block);
        DataUtils.appendMap(stringBuilder, "len", this.len);
        if (this.maxLen != this.maxLenLive) {
            DataUtils.appendMap(stringBuilder, "liveMax", this.maxLenLive);
        }
        if (this.pageCount != this.pageCountLive) {
            DataUtils.appendMap(stringBuilder, "livePages", this.pageCountLive);
        }
        DataUtils.appendMap(stringBuilder, "map", this.mapId);
        DataUtils.appendMap(stringBuilder, "max", this.maxLen);
        if (this.next != 0L) {
            DataUtils.appendMap(stringBuilder, "next", this.next);
        }
        DataUtils.appendMap(stringBuilder, "pages", this.pageCount);
        DataUtils.appendMap(stringBuilder, "root", this.metaRootPos);
        DataUtils.appendMap(stringBuilder, "time", this.time);
        if (this.unused != 0L) {
            DataUtils.appendMap(stringBuilder, "unused", this.unused);
        }
        DataUtils.appendMap(stringBuilder, "version", this.version);
        return stringBuilder.toString();
    }

    byte[] getFooterBytes() {
        StringBuilder stringBuilder = new StringBuilder(128);
        DataUtils.appendMap(stringBuilder, "chunk", this.id);
        DataUtils.appendMap(stringBuilder, "block", this.block);
        DataUtils.appendMap(stringBuilder, "version", this.version);
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        int n = DataUtils.getFletcher32(byArray, 0, byArray.length);
        DataUtils.appendMap(stringBuilder, "fletcher", n);
        while (stringBuilder.length() < 127) {
            stringBuilder.append(' ');
        }
        stringBuilder.append('\n');
        return stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    public String toString() {
        return this.asString();
    }
}

